-- FUNCTION: public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer, integer)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_conv(
	integer,
	integer,
	integer,
	integer,
	integer,
	integer,
	integer,
	integer,
	integer)
	
--RETURNS SETOF public.rs_tab_desc_prod_conv AS
--$body$
    RETURNS SETOF rs_tab_desc_prod_conv 
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE 
    ROWS 1000
AS $BODY$

-- versã£o 23/09/2022 



 --<<inicio do corpo da funcao
-- function: select * from ufd_est_prod_tbl_desc_conv(1, 2, 3, 101, 1 , 0)
/*  
 empresa: vetor solucoes
 funo:  ufd_est_prod_tbl_desc_conv
 objetivo: retornar descontos do produto em tabela de desconto
 autor:  fernando junio cunha e sousa  
 criacao: 06/2012  
 coments: alterada em 12/2012 para acrescentar o controle da flag_somente_desc_contrato no cadastro convenio
			 editada por: fernando junio cunha e sousa 
 int_cd_emp          --- codigo da empresa  
 int_cd_filial       --- codigo da filial  
 int_cd_prod         --- codigo do produto  
 int_cd_cli          --- codigo do cliente para retorno de desconto para cliente 
 int_cd_conv         --- codigo do convenio ( caso seja conveniado,se nao for deve-se passar zero)  
 int_is_receita     --- indica se e venda com receita ou nãƒo
*/ 
--declara as variaveis usadas na funcao
declare
---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------


int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_prod             alias for $3;
int_cd_cli             	alias for $4;
int_cd_conv	            alias for $5;
int_is_receita          alias for $6;
int_libera_vd_conv      alias for $7;
int_cd_forma_pgto       alias for $8;
int_usa_desconto_propz_ident ALIAS FOR $9;


---------------------------------------------------------
---fim
---------------------------------------------------------
returnrec rs_tab_desc_prod_conv; --recebera os dados de retorno da funcao


--declarando variavel para teste da flag 
vr_cd_plano_venda                   integer;
vr_qtde_prod_max_conv               integer;
vr_qtde_prod_max_conv_by_prod       integer;
vr_libera_vd_conv                   integer;
vr_procedure_desc_extra             character varying(250);
var_trabalhacomdescontoformadepagamento 	integer;


/*vr_cd_tbl_desc                      integer;
vr_tp_desc                          integer;
vr_flag_desc_fix                    integer;
vr_perc_desc                        double precision;
vr_perc_desc_max                    double precision;
vr_tp_nivel                         integer;
vr_exclue_oferta                    integer;
*/
begin --inicio dos blocos da funcao
	-- setando valores iniciais
	vr_cd_plano_venda             = 0;
	vr_qtde_prod_max_conv         = -1;
	vr_qtde_prod_max_conv_by_prod = -1;
	vr_procedure_desc_extra       = '';
	vr_libera_vd_conv             = int_libera_vd_conv;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_tab_desc_prod_conv
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			flag_desc_fix 		integer,
			perc_desc			double precision,
			perc_desc_max		double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone,
			libera_vd_conv      integer,
			exclue_oferta       integer,
			qt_max              integer
		);
		exception when others then
		truncate table temp_tab_desc_prod_conv; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_ativa_conv
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		exception when others then
		truncate table rs_tab_ativa_conv; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
		truncate table rs_est_prod_arv_merc; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	if int_cd_conv > 0 then
		-------------------------------------------------------------------------------------------------------------------------------
		--buscando arvore merc. do produto
		-------------------------------------------------------------------------------------------------------------------------------	
		insert into rs_est_prod_arv_merc		
			select 
				arv.cd_emp					,
				arv.cd_prod					,
				arv.cd_arv_merc_categ		,
				arv.cd_arv_merc_linha		,
				arv.cd_mc					,
				arv.cd_arv_merc_familia		,												
				p.cd_fabric 
			from 	est_prod_est_arv_mercadologica arv inner join est_prod p on
					arv.cd_emp		= p.cd_emp
					and arv.cd_prod = p.cd_prod
			where   	arv.cd_emp = int_cd_emp
				and 	arv.cd_prod = int_cd_prod;
		--raise notice 'cd_arv_merc_linha %', (select cd_arv_merc_linha from rs_est_prod_arv_merc limit 1);
	
	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'usa_desconto_pgto' and cd_filial = int_cd_filial), 0);


	
	if exists (select 1 from rs_est_prod_arv_merc) then
		
		-- capturando plano de venda
			vr_cd_plano_venda = coalesce((select
											    coalesce(rc_cli_conv_rc_cli.cd_plano_venda,0)
									  	    from rc_cli_conv_rc_cli 	
										   where int_cd_emp  = rc_cli_conv_rc_cli.cd_emp 
										     and int_cd_cli  = rc_cli_conv_rc_cli.cd_cli
										     and int_cd_conv = rc_cli_conv_rc_cli.cd_conv
										   ),0);
										  
			-- todas as tabelas que nao exite receita
			insert into rs_tab_ativa_conv    
				select  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				from	est_prod_tbl_desc a inner join 
				        est_prod_tbl_desc_prc_filial fil on    
							a.cd_emp = fil.cd_emp and    
							a.cd_tbl_desc = fil.cd_tbl_desc inner join
						rc_cli_conv_est_prod_tbl_desc conv on     
							a.cd_emp = conv.cd_emp and 
							a.cd_tbl_desc = conv.cd_tbl_desc and 
							int_cd_conv = conv.cd_conv and 
							vr_cd_plano_venda = conv.cd_plano_venda  
				where	int_cd_emp = a.cd_emp and     
                        int_cd_filial = fil.cd_filial and		
						current_date between date(a.dt_ini) and date(a.dt_fim) and
						1 = a.sts_tbl_desc and    
						3 = a.cd_tp_desconto and 
						a.flag_desc_receita = 0
						AND	(
					      ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR 
					      ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
					    );
						
			-- inclui as tabelas que exite receita			
			if 	int_is_receita > 0 then		
				insert into rs_tab_ativa_conv    
					select  a.cd_emp,    
							a.cd_tbl_desc,    
							a.cd_tp_desconto
					from est_prod_tbl_desc a inner join 
					     est_prod_tbl_desc_prc_filial fil on    
							a.cd_emp = fil.cd_emp and    
							a.cd_tbl_desc = fil.cd_tbl_desc inner join
					     rc_cli_conv_est_prod_tbl_desc conv on     
							a.cd_emp = conv.cd_emp and 
							a.cd_tbl_desc = conv.cd_tbl_desc and 
							int_cd_conv = conv.cd_conv and 
							vr_cd_plano_venda = conv.cd_plano_venda    
					where	int_cd_emp = a.cd_emp and   
                            int_cd_filial = fil.cd_filial and	
							current_date between date(a.dt_ini) and date(a.dt_fim) and
							1 = a.sts_tbl_desc and    
							3 = a.cd_tp_desconto and 
							a.flag_desc_receita = 1
						AND	(
					      ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR
					      ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
					    );
						
			end if;
			
				--raise notice 'var_trabalhacomdescontoformadepagamento %.',var_trabalhacomdescontoformadepagamento;
	
		if var_trabalhacomdescontoformadepagamento = 1 then  
			
			   delete from rs_tab_ativa_conv a 
				where not exists (select b.cd_emp
								    from est_prod_tbl_desc_forma_pgto b  
								   where b.cd_emp        = a.cd_emp
									 and b.cd_tbl_desc   = a.cd_tbl_desc   
									 and b.cd_forma_pgto = int_cd_forma_pgto  
										) ;
		
			end if ; 
			
			
			
			
			
			
			if exists (select 1 from rs_tab_ativa_conv) then
			-------------------------------------------------------------------------------------------------------------------------------
				-- captura de quantidade de produto
				-------------------------------------------------------------------------------------------------------------------------------
				vr_qtde_prod_max_conv = coalesce((select coalesce(valor, '-1')::integer from prc_emp_config where cd_emp = 1 and cd_chave ilike 'convenio_limite_produtos'), '-1')::integer;
				vr_qtde_prod_max_conv_by_prod = coalesce((select coalesce(qtde_prod, -1) from rc_cli_conv_est_prod_conv_limite where int_cd_conv = cd_conv and int_cd_prod = cd_prod ),-1);
				if vr_qtde_prod_max_conv_by_prod > -1 then
					vr_qtde_prod_max_conv = vr_qtde_prod_max_conv_by_prod;		
				end if; 
				-- fim captura de quantidade de produto
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 1 - produtos    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_conv     
					  select    
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc as perc_desc,    
							b.perc_desc_max as perc_desc_max,    
							1 as tp_nivel,
							a.dt_ini    
					  from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_prod b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_tab_ativa_conv on    
								b.cd_emp = rs_tab_ativa_conv.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc     
							inner join rs_est_prod_arv_merc arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_prod = arv.cd_prod           
					  where     
								int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 2 - familias    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_conv     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc as perc_desc,    
							b.perc_desc_max as perc_desc_max,   
							2 as tp_nivel,
							a.dt_ini    
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_arv_merc_familia b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
							inner join rs_tab_ativa_conv on    
								a.cd_emp = rs_tab_ativa_conv.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					where     
							int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------        
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 3 - marcas    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_conv     
					select
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc as perc_desc,    
							b.perc_desc_max as perc_desc_max,   
							3 as tp_nivel,
							a.dt_ini    
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_mc b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_mc = arv.cd_mc    
							inner join rs_tab_ativa_conv on    
								a.cd_emp = rs_tab_ativa_conv.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					where     
							int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 4 - fabricantes    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_conv     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc as perc_desc,    
							b.perc_desc_max as perc_desc_max,   
							4 as tp_nivel,
							a.dt_ini     
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_prod_fabric b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_fabric = arv.cd_fabric     
							inner join rs_tab_ativa_conv on    
								b.cd_emp = rs_tab_ativa_conv.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					where     
							int_cd_filial = fil.cd_filial;
				------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 5 - categorias         
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_conv     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc as perc_desc,    
							b.perc_desc_max as perc_desc_max,   
							5 as tp_nivel,
							a.dt_ini  
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_arv_merc_categoria b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
							inner join rs_tab_ativa_conv on    
								a.cd_emp = rs_tab_ativa_conv.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					where     
							int_cd_filial = fil.cd_filial;
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 6 - linhas
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_conv     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							a.flag_desc_fix,    
							b.perc_desc as perc_desc,    
							b.perc_desc_max as perc_desc_max,   
							6 as tp_nivel,
							a.dt_ini 
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_arv_merc_linha b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc arv on    
								b.cd_emp = arv.cd_emp and       
								b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
							inner join rs_tab_ativa_conv on    
								a.cd_emp = rs_tab_ativa_conv.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_conv.cd_tbl_desc        
					where     
							int_cd_filial = fil.cd_filial;
				-- validando bloqueio de venda em filial
				if exists ( select cd_filial from rc_cli_conv_prc_filial_blq where	cd_emp =int_cd_emp and cd_filial = int_cd_filial and cd_conv = int_cd_conv ) then
					vr_libera_vd_conv = 0;
				end if;	--if exists ( select cd_filial from rc_cli_conv_prc_filial_blq ...
				update 
					temp_tab_desc_prod_conv set 
						libera_vd_conv = vr_libera_vd_conv ,
						exclue_oferta  = 0 ,
						qt_max         = vr_qtde_prod_max_conv;
				vr_procedure_desc_extra =  coalesce((
												select 
														coalesce(a.procedure_desconto, 'n') as procedure_desconto
												from  	rc_cli_conv as a
												where  	a.cd_emp = int_cd_emp and 
														a.cd_conv = int_cd_conv
											), 'n');
				--raise notice 'vr_procedure_desc_extra %', vr_procedure_desc_extra;											
				if vr_procedure_desc_extra <> 'n' then
					if exists (select 1 from pg_proc where proname = vr_procedure_desc_extra) then
						execute 'select cd_tbl_desc ,tp_desc ,flag_desc_fix ,perc_desc ,perc_desc_max ,tp_nivel ,libera_vd_conv ,exclue_oferta ,qt_max from ' || vr_procedure_desc_extra || '( $1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11 )' 
						   into returnrec
						   using int_cd_emp,
								 int_cd_filial,
								 int_cd_prod,
								 int_cd_cli,
								 int_cd_conv,
								 vr_cd_plano_venda,
								 int_is_receita,							 
								 vr_libera_vd_conv,
								 vr_qtde_prod_max_conv,
								 (select perc_desc      from temp_tab_desc_prod_conv),
								 (select exclue_oferta  from temp_tab_desc_prod_conv);
						return next returnrec;
					end if;
				end if; --if vr_procedure_desc_extra <> 'n' then
			end if;	--if exists (select 1 from rs_tab_qtde_ativa) then	
		end if; --if exists (select 1 from rs_est_prod_arv_merc) then
	end if; --if int_cd_conv > 0 then
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------
	for returnrec in 
		select 
			cd_tbl_desc, 
			tp_desc, 
			flag_desc_fix, 
			perc_desc, 
			case when perc_desc_max=0 and perc_desc > perc_desc_max then
											perc_desc else perc_desc_max  end  as perc_desc_max, tp_nivel, libera_vd_conv, exclue_oferta, qt_max 
		  from temp_tab_desc_prod_conv 
		 --order by tp_nivel asc, perc_desc desc, dt_ini desc limit 1
		 order by tp_nivel asc, perc_desc desc , dt_ini desc limit 1
	loop
		return next returnrec;
	end loop;				

END; --FIM DOS BLOCOS DA FUNCAO

$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer, integer, integer)
    OWNER TO postgres;

/*	
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_conv(integer, integer, integer, integer, integer, integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_prod_conv AS
$body$
DECLARE RET rs_tab_desc_prod_conv;
BEGIN
  RET = ufd_est_prod_tbl_desc_conv($1, $2, $3, $4, $5, $6, $7, $8, 0);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;
*/